<?php

class ControladorCaja {
    static public function ctrCrearAperturaCaja($datos){
        $table = "caja";
        $respuesta = ModeloCaja::mdlIngresarAperturaCaja($table, $datos);
        return $respuesta;
    }

    static public function ctrValidarApertura($datos){
        $table = "caja";
        $respuesta = ModeloCaja::mdlValidarApertura($table, $datos);
        //var_dump($respuesta); die();
        return $respuesta;
    }
    static public function ctrValidarAperturaModal($datos){
        $table = "caja";
        $respuesta = ModeloCaja::mdlValidarAperturaModal($table, $datos);
        //var_dump($respuesta); die();
        return $respuesta;
    }

    /* funcion que se ejecuta desde la vista de historia-caja.php dentro del formulario
       para posteriormente guardarlo en la base de datos */
    static public function ctrCerrarCaja(){
        date_default_timezone_set("America/Lima");
		setlocale(LC_ALL, 'spanish');
        if(isset($_POST['btnCerrarCaja'])){
            if(!empty($_POST['saldoSiguiente']) && $_POST['saldoSiguiente'] != 0){
                //echo str_replace(',','',$_POST['totalComercial']);
                $data = [
                    "totalComercial" => str_replace(',','',$_POST['totalComercial']),
                    "totalDomiciliario" => str_replace(',','',$_POST['totalDomiciliario']),
                    "totalIngreso" => str_replace(',','',$_POST['subTotalIngreso']),
                    "totalEntregado" => str_replace(',','',$_POST['totalEntregar']),
                    "saldoSigiente" => str_replace(',','',$_POST['saldoSiguiente']),
                    'fechaCierre' => date('Y-m-d'),
                    "estadoCierre" => "Cerrado",
                    "id" => $_POST['codigoCaja']
                ];

                $respuesta = ModeloCaja::mdlCerrarCaja("caja", $data);

                if($respuesta == "ok"){
                    // Eliminar el nombre de usuario:
                    unset($_SESSION["idCaja"]);
					echo'<script>

					swal({
						  type: "success",
						  title: "Caja cerrada con exito",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "consulta-caja";

									}
								})

					</script>';

				}
                //echo "<script>alert('ingresaste a la función')</script>";
            } else {
                echo'<script>

					swal({
						  type: "error",
						  title: "¡Debes de Calcular la venta antes de continuar!",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
							if (result.value) {

							}
						})

			  	</script>';
            }

        }

    }

    // consultar solo el saldo anterior de la caja
    static public function ctrSaldoAnterior(){
        $fecha = date("Y")."-".date("m")."-". (date("d")-1);
        $idUsuario = $_SESSION['id'];

        $respuesta = ModeloCaja::mdlConsultarSaldoAnterior($fecha, $idUsuario);
        if($respuesta == null){
            return  0;
        } else {
            return $respuesta;
        }

    }

    // consultar caja
    static public function ctrConsultarCaja($idCaja, $estado = null){
        $datos = null;
        $valor[0] = $idCaja;
        if($estado != null){
            $valor[1] = $estado;
        }else {
            $valor[1] = "Cerrado";
        }
        //$valor[1] = "Apertura";
        
        $tabla = "caja";
        $item = "id"; //equivale al idCaja solo que se hace la consulta con una vista
        $caja = ModeloCaja::mdlConsultarCaja($tabla, $item, $valor);
        if(is_array($caja) && !empty($caja)){
            //var_dump($caja[0]['AperturaCaja']);
            $datos['caja'] = $caja[0];
            $totalComercial = ModeloCaja::mdlImporteSegunConcepto("Comercio", $idCaja);
            $datos['totalComercial'] = $totalComercial;
            $totalDomiciliar = ModeloCaja::mdlImporteSegunConcepto("Domiciliario", $idCaja);
            $datos['totalDomiciliar']  = $totalDomiciliar;
            $datos['subTotal'] = $totalComercial + $totalDomiciliar;
            $datos['ingresoBruto'] = $caja[0]['totalIngreso'] + $caja[0]['AperturaCaja'];



        }


        return $datos;
    }

    static public function ctrMostrarCajas($idUsuario = null, $item = null, $fecha1 = null, $fecha2 = null){
        $tabla = "tablacaja";
        if($item == null){
            $item = "idUsuario";
        }
        if($idUsuario == null){
            $idUsuario = $_SESSION['id'];
        }

        if($_SESSION["perfil"] == "Administrador"){
            $item = "";
        }
        
        $valor[0] = $idUsuario;
        $valor[1] = "Cerrado";
        $data = ModeloCaja::mdlConsultarCaja($tabla, $item, $valor, $fecha1, $fecha2);
        return $data;
    }

    static public function ctrMostrarDetalleCaja($idCaja){
        $tabla = "detallecaja";
        $data = ModeloCaja::mdlConsultarDetalleCaja($tabla, $idCaja);
        return $data;
    }

    static public function ctrMostrarDetalleCajaMovimiento($idUsuario = null, $fecha1 = null, $fecha2 = null){
        $tabla = "detallecaja";
        $idCaja = null;

        if($idUsuario != null){
            $idCaja = "";
            $cajasUsuario = ModeloCaja::mdlConsultarCajaUsuario("caja",$idUsuario);
            foreach($cajasUsuario as $key => $datos){
                if((count($cajasUsuario) - 1) == $key)
                    $idCaja .= $datos['id'];
                else
                    $idCaja .= $datos['id'].",";
            }
        }
        
        $data = ModeloCaja::mdlConsultarDetalleCajaMovimiento($tabla,$idCaja, $fecha1, $fecha2);
        return $data;
    }
}
// consulta para tabla de caja
//select c.id, fechaRegistro, usu.nombre, AperturaCaja, totalComercial, totalDomiciliario, totalIngreso, totalEntregado, saldoSigiente, estadoCierre from caja as c inner join usuarios as usu ON c.idUsuario=usu.id

//select sum(importeCaja) as suma from detalleCaja where idCaja = 34 and concepto = "Comercial"



//mostrar historial de caja
//select id, fechaRegistro, tipoCaja, concepto, numeroDocumento, tipoPago, importeCaja, estadoCaja from detalleCaja where idCaja = 19
